
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Name - Address'); ?></th>
                                    <th><?php echo app('translator')->get('Email - Phone'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Creations Date'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Name - Address'); ?>">
                                        <span class="font-weight-bold"><?php echo e(__($branch->name)); ?></span><br>
                                        <span><?php echo e($branch->address); ?></span>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Email - Phone'); ?>">
                                        <span class="font-weight-bold"><?php echo e($branch->email); ?></span><br>
                                        <span><?php echo e($branch->phone); ?></span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php if($branch->status == 1): ?>
                                            <span class="badge badge--success"><?php echo app('translator')->get('Open'); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge--danger"><?php echo app('translator')->get('Closed'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Creations Date'); ?>">
                                         <?php echo e(showDateTime($branch->created_at)); ?> <br> <?php echo e(diffForHumans($branch->created_at)); ?>

                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <a href="javascript:void(0)" class="icon-btn btn--primary ml-1 editBrach"
                                            data-id="<?php echo e($branch->id); ?>"
                                            data-name="<?php echo e($branch->name); ?>"
                                            data-email="<?php echo e($branch->email); ?>"
                                            data-phone="<?php echo e($branch->phone); ?>"
                                            data-address="<?php echo e($branch->address); ?>"
                                            data-status ="<?php echo e($branch->status); ?>"
                                        ><i class="las la-edit"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($branchs)); ?>

                </div>
            </div>
        </div>
    </div>


    <div id="branchModel" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Create New Branch'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.branch.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="name" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" class="form-control form-control-lg" name="name" placeholder="<?php echo app('translator')->get("Enter Name"); ?>"  maxlength="40" required="">
                        </div>

                        <div class="form-group">
                            <label for="email" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Email Address'); ?></label>
                            <input type="email" class="form-control form-control-lg" name="email" placeholder="<?php echo app('translator')->get("Enter Email"); ?>"  maxlength="40" required="">
                        </div>

                        <div class="form-group">
                            <label for="phone" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Phone'); ?></label>
                            <input type="text" class="form-control form-control-lg" name="phone" placeholder="<?php echo app('translator')->get("Enter Phone"); ?>"  maxlength="40" required="">
                        </div>


                        <div class="form-group">
                            <label for="address" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Address'); ?></label>
                            <input type="text" class="form-control form-control-lg" name="address" placeholder="<?php echo app('translator')->get("Enter Address"); ?>"  maxlength="255" required="">
                        </div>


                        <div class="form-group">
                            <label class="form-control-label font-weight-bold"><?php echo app('translator')->get('Status'); ?> </label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger"
                                data-toggle="toggle" data-on="<?php echo app('translator')->get('Open'); ?>" data-off="<?php echo app('translator')->get('Closed'); ?>" name="status">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn--primary"><i class="fa fa-fw fa-paper-plane"></i><?php echo app('translator')->get('Create Branch'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div id="updateBranchModel" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Update Branch'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.branch.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="name" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" class="form-control form-control-lg" name="name" placeholder="<?php echo app('translator')->get("Enter Name"); ?>"  maxlength="40" required="">
                        </div>

                        <div class="form-group">
                            <label for="email" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Email Address'); ?></label>
                            <input type="email" class="form-control form-control-lg" name="email" placeholder="<?php echo app('translator')->get("Enter Email"); ?>"  maxlength="40" required="">
                        </div>

                        <div class="form-group">
                            <label for="phone" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Phone'); ?></label>
                            <input type="text" class="form-control form-control-lg" name="phone" placeholder="<?php echo app('translator')->get("Enter Phone"); ?>"  maxlength="40" required="">
                        </div>


                        <div class="form-group">
                            <label for="address" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Address'); ?></label>
                            <input type="text" class="form-control form-control-lg" name="address" placeholder="<?php echo app('translator')->get("Enter Address"); ?>"  maxlength="255" required="">
                        </div>


                        <div class="form-group">
                            <label class="form-control-label font-weight-bold"><?php echo app('translator')->get('Status'); ?> </label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger"
                                data-toggle="toggle" data-on="<?php echo app('translator')->get('Open'); ?>" data-off="<?php echo app('translator')->get('Closed'); ?>" name="status">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn--primary"><i class="fa fa-fw fa-paper-plane"></i><?php echo app('translator')->get('Update Branch'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="javascript:void(0)" class="btn btn-sm btn--primary box--shadow1 text--small addNewBrach" ><i class="fa fa-fw fa-paper-plane"></i><?php echo app('translator')->get('Create New Branch'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        $('.addNewBrach').on('click', function() {
            $('#branchModel').modal('show');
        });
        
        $('.editBrach').on('click', function() {
            var modal = $('#updateBranchModel');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.find('input[name=name]').val($(this).data('name'));
            modal.find('input[name=email]').val($(this).data('email'));
            modal.find('input[name=phone]').val($(this).data('phone'));
            modal.find('input[name=address]').val($(this).data('address'));
            var data = $(this).data('status');
            if(data == 1){
                modal.find('input[name=status]').bootstrapToggle('on');
            }else{
                modal.find('input[name=status]').bootstrapToggle('off');
            }
            modal.modal('show');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highogyr/public_html/core/resources/views/admin/branch/index.blade.php ENDPATH**/ ?>